using System;
using Server.ContextMenus;
using System.Collections;
using System.Collections.Generic;

namespace Server.Items
{
	public class ShipwreckedItem : Item, IDyable
	{
		[Constructable]
      public ShipwreckedItem( int itemID ) : base( itemID )
		{
			int weight = this.ItemData.Weight;

			if ( weight >= 255 )
				weight = 1;

			this.Weight = weight;
			
			if ( ItemID == 3824 )
			{
			   Stackable = true;
			   Weight = 0.01;
			   Hue = 2967;
			   Name = "old coins";
         }
		}
		
		[Constructable]
		public ShipwreckedItem() : this( 3826 )
		{
			Stackable = true;
			Weight = 0.01;
			Hue = 2967;
			Name = "old coins";
		}

// 		public override void OnSingleClick( Mobile from )
// 		{
// 			this.LabelTo( from, 1050039, String.Format( "#{0}\t#1041645", LabelNumber ) );
// 		}

		public override void AddNameProperties( ObjectPropertyList list )
		{
			base.AddNameProperties( list );
			list.Add( 1041645 ); // recovered from a shipwreck
		}
		
      public override void GetContextMenuEntries( Mobile from, List<ContextMenuEntry> list )
      {
          base.GetContextMenuEntries( from, list );

          if ( this.BlessedFor == null && this.ItemID != 3824 && this.IsChildOf( from.Backpack ) )
             list.Add( new DisassembleEntry( from, this ) );
      }

      public class DisassembleEntry : ContextMenuEntry
      {
          private Mobile m_From;
          private Item m_item;

          public DisassembleEntry( Mobile from, Item item ) : base(6142, 1)//Disassemble
          {
              m_From = from;
              m_item = item;
          }

          public override void OnClick()
          {
              if ( m_item == null || m_item.Deleted )
               return;
              
              if ( !m_item.IsChildOf( m_From.Backpack ) )
                  m_From.SendLocalizedMessage( 1042001 ); // That must be in your pack for you to use it.
              else if (  m_item.ItemID != 3824 )
              {
                  m_item.ItemID = 3824;
                  m_item.Hue = 2967;
                  m_item.Name = "old coins";
                  m_item.Stackable = true;
                  m_item.Weight = 0.01;
                  
        				if ( m_item.Parent is BaseContainer )
        				{
        					BaseContainer baglik = (BaseContainer)m_item.Parent;
        
        					if ( baglik != null )
        					{
        					   List<Item> baglikItems = baglik.Items;
        					   ArrayList toDelete = new ArrayList();
        					   
        					   for ( int x = 0; x < baglikItems.Count; ++x )
        					   {
                            if ( baglikItems[x] == null || baglikItems[x] == m_item || baglikItems[x].Deleted )
                              continue;
                            
                            if ( baglikItems[x] is ShipwreckedItem && baglikItems[x].ItemID != 3824 )
                            {
                                 m_item.Amount += baglikItems[x].Amount;
                                 toDelete.Add( baglikItems[x] );
                            }
                        }
                        
                        foreach ( Item item in toDelete )
			                  item.Delete();
                     }
        				}
        			}
          }
      }
      
		public override int GetDropSound()
		{
    		if ( this.ItemID == 3824 )
    		{
            if ( Amount <= 1 )
    				return 0x2E4;
    			else if ( Amount <= 5 )
    				return 0x2E5;
    			else
    				return 0x2E6;
         }
         
         return base.GetDropSound();
		}

		public ShipwreckedItem( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
		}

		public bool Dye( Mobile from, DyeTub sender )
		{
			if ( Deleted )
				return false;

			if ( ItemID >= 0x13A4 && ItemID <= 0x13AE )
			{
				Hue = sender.DyedHue;
				return true;
			}

			from.SendLocalizedMessage( sender.FailMessage );
			return false;
		}
	}
}